#include <stdint.h>
#include "os_patch.h"


void os_patch_check()
{
    extern uint8_t *ucHeapStart;
    extern uint8_t *ucHeapEnd;

    // heap check
    if (ucHeapStart == 0 || ucHeapEnd == 0 || ucHeapStart > ucHeapEnd) {
        /* Heap Start and End need init */
        vPortEnterCritical();

        while (1);
    }

    extern idle_ftable_t g_idle_ftable;

    if (!g_idle_ftable.h_vApplicationGetIdleTaskMemory) {
        vPortEnterCritical();

        while (1);
    }

    extern tick_ftable_t g_tick_ftable;

    if (!g_tick_ftable.h_vConfigureTickInterrupt) {
        vPortEnterCritical();

        while (1);
    }

    extern timers_ftable_t g_timers_ftable;

    if (!g_timers_ftable.h_vApplicationGetTimerTaskMemory) {
        vPortEnterCritical();

        while (1);
    }
}