/* Standard includes. */
#include <stdio.h>
#include <stdint.h>

#include "os_patch.h"

err_ftable_t g_err_ftable;

void vApplicationStackOverflowHook(TaskHandle_t pxTask, char *pcTaskName)
{
    if (g_err_ftable.h_vApplicationStackOverflowHook) {
        g_err_ftable.h_vApplicationStackOverflowHook(pxTask, pcTaskName);
    }

    vPortEnterCritical();

    while (1);
}


void vAssertCalled(const char * pcFile, unsigned long ulLine)
{
    if (g_err_ftable.h_vAssertCalled) {
        g_err_ftable.h_vAssertCalled(pcFile, ulLine);
    }

    vPortEnterCritical();

    while (1);
}


