
#ifndef _OS_PATCH_H_
#define _OS_PATCH_H_
/* Kernel includes. */
#include "FreeRTOS.h"
#include "task.h"
#include "timers.h"
#include "semphr.h"

typedef struct {
    void (*h_vApplicationStackOverflowHook)(TaskHandle_t pxTask, char *pcTaskName);
    void (*h_vAssertCalled)(const char * pcFile, unsigned long ulLine);
} err_ftable_t;


typedef struct {
    void *(*h_pvPortMalloc)(size_t xWantedSize);
    void (*h_vPortFree)(void *pv);
    void (*h_vPortInitialiseBlocks)(void);
    size_t (*h_xPortGetFreeHeapSize)(void);
    void (*h_vApplicationMallocFailedHook)(void);
} heap_ftable_t;

typedef struct {
    void (*h_vApplicationIdleHook)(void);
    void (*h_vApplicationGetIdleTaskMemory)(StaticTask_t **ppxIdleTaskTCBBuffer,
                                            StackType_t **ppxIdleTaskStackBuffer,
                                            uint32_t *pulIdleTaskStackSize);
} idle_ftable_t;


typedef struct {
    void (*h_vConfigureTickInterrupt)(void);
    void (*h_vClearTickInterrupt)(void);
} tick_ftable_t;


typedef struct {
    void (*h_vApplicationGetTimerTaskMemory)(StaticTask_t **ppxTimerTaskTCBBuffer,
            StackType_t **ppxTimerTaskStackBuffer,
            uint32_t *pulTimerTaskStackSize);
} timers_ftable_t;


typedef struct {
    void *(*h_co_mem_malloc)(uint16_t size);
    void (*h_co_mem_free)(void *pMem);
} mem_ftable_t;

#endif