/*
    FreeRTOS V9.0.0 - Copyright (C) 2016 Real Time Engineers Ltd.
    All rights reserved

    VISIT http://www.FreeRTOS.org TO ENSURE YOU ARE USING THE LATEST VERSION.

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation >>>> AND MODIFIED BY <<<< the FreeRTOS exception.

    ***************************************************************************
    >>!   NOTE: The modification to the GPL is included to allow you to     !<<
    >>!   distribute a combined work that includes FreeRTOS without being   !<<
    >>!   obliged to provide the source code for proprietary components     !<<
    >>!   outside of the FreeRTOS kernel.                                   !<<
    ***************************************************************************

    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  Full license text is available on the following
    link: http://www.freertos.org/a00114.html

    ***************************************************************************
     *                                                                       *
     *    FreeRTOS provides completely free yet professionally developed,    *
     *    robust, strictly quality controlled, supported, and cross          *
     *    platform software that is more than just the market leader, it     *
     *    is the industry's de facto standard.                               *
     *                                                                       *
     *    Help yourself get started quickly while simultaneously helping     *
     *    to support the FreeRTOS project by purchasing a FreeRTOS           *
     *    tutorial book, reference manual, or both:                          *
     *    http://www.FreeRTOS.org/Documentation                              *
     *                                                                       *
    ***************************************************************************

    http://www.FreeRTOS.org/FAQHelp.html - Having a problem?  Start by reading
    the FAQ page "My application does not run, what could be wrong?".  Have you
    defined configASSERT()?

    http://www.FreeRTOS.org/support - In return for receiving this top quality
    embedded software for free we request you assist our global community by
    participating in the support forum.

    http://www.FreeRTOS.org/training - Investing in training allows your team to
    be as productive as possible as early as possible.  Now you can receive
    FreeRTOS training directly from Richard Barry, CEO of Real Time Engineers
    Ltd, and the world's leading authority on the world's leading RTOS.

    http://www.FreeRTOS.org/plus - A selection of FreeRTOS ecosystem products,
    including FreeRTOS+Trace - an indispensable productivity tool, a DOS
    compatible FAT file system, and our tiny thread aware UDP/IP stack.

    http://www.FreeRTOS.org/labs - Where new FreeRTOS products go to incubate.
    Come and try FreeRTOS+TCP, our new open source TCP/IP stack for FreeRTOS.

    http://www.OpenRTOS.com - Real Time Engineers ltd. license FreeRTOS to High
    Integrity Systems ltd. to sell under the OpenRTOS brand.  Low cost OpenRTOS
    licenses offer ticketed support, indemnification and commercial middleware.

    http://www.SafeRTOS.com - High Integrity Systems also provide a safety
    engineered and independently SIL3 certified version for use in safety and
    mission critical applications that require provable dependability.

    1 tab == 4 spaces!
*/

#ifndef ISR_SUPPORT_H
#define ISR_SUPPORT_H

#include "FreeRTOSConfig.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef configSUPPORT_FPU
#if defined(__NDS32_EXT_FPU_DP__) || defined(__NDS32_EXT_FPU_SP__)
#define configSUPPORT_FPU 1
#else
#define configSUPPORT_FPU 0
#endif
#endif

#ifndef configSUPPORT_IFC
#ifdef __NDS32_EXT_IFC__
#define configSUPPORT_IFC 1
#else
#define configSUPPORT_IFC 0
#endif
#endif

#ifndef configSUPPORT_ZOL
#define configSUPPORT_ZOL 0
#endif

/* The used register numbers of FPU context */
#if ( configSUPPORT_FPU == 1 )
#if defined(__NDS32_EXT_FPU_CONFIG_0__)
#define portFPU_REGS    8
#elif defined(__NDS32_EXT_FPU_CONFIG_1__)
#define portFPU_REGS    16
#elif defined(__NDS32_EXT_FPU_CONFIG_2__)
#define portFPU_REGS    32
#elif defined(__NDS32_EXT_FPU_CONFIG_3__)
#define portFPU_REGS    64
#endif
#endif

/*-----------------------------------------------------------*/

#ifdef __ASSEMBLER__

.macro portSAVE_FPU
#if ( configSUPPORT_FPU == 1 )
addi    $sp, $sp, -8
#if ( portFPU_REGS > 32 )
fsdi.bi $fd31, [$sp], -8
fsdi.bi $fd30, [$sp], -8
fsdi.bi $fd29, [$sp], -8
fsdi.bi $fd28, [$sp], -8
fsdi.bi $fd27, [$sp], -8
fsdi.bi $fd26, [$sp], -8
fsdi.bi $fd25, [$sp], -8
fsdi.bi $fd24, [$sp], -8
fsdi.bi $fd23, [$sp], -8
fsdi.bi $fd22, [$sp], -8
fsdi.bi $fd21, [$sp], -8
fsdi.bi $fd20, [$sp], -8
fsdi.bi $fd19, [$sp], -8
fsdi.bi $fd18, [$sp], -8
fsdi.bi $fd17, [$sp], -8
fsdi.bi $fd16, [$sp], -8
#endif
#if ( portFPU_REGS > 16 )
fsdi.bi $fd15, [$sp], -8
fsdi.bi $fd14, [$sp], -8
fsdi.bi $fd13, [$sp], -8
fsdi.bi $fd12, [$sp], -8
fsdi.bi $fd11, [$sp], -8
fsdi.bi $fd10, [$sp], -8
fsdi.bi $fd9, [$sp], -8
fsdi.bi $fd8, [$sp], -8
#endif
#if ( portFPU_REGS > 8 )
fsdi.bi $fd7, [$sp], -8
fsdi.bi $fd6, [$sp], -8
fsdi.bi $fd5, [$sp], -8
fsdi.bi $fd4, [$sp], -8
#endif
fsdi.bi $fd3, [$sp], -8
fsdi.bi $fd2, [$sp], -8
fsdi.bi $fd1, [$sp], -8
fsdi    $fd0, [$sp + 0]
#endif
.endm

.macro portRESTORE_FPU
#if ( configSUPPORT_FPU == 1 )
fldi.bi $fd0, [$sp], 8
fldi.bi $fd1, [$sp], 8
fldi.bi $fd2, [$sp], 8
fldi.bi $fd3, [$sp], 8
#if ( portFPU_REGS > 8 )
fldi.bi $fd4, [$sp], 8
fldi.bi $fd5, [$sp], 8
fldi.bi $fd6, [$sp], 8
fldi.bi $fd7, [$sp], 8
#endif
#if ( portFPU_REGS > 16 )
fldi.bi $fd8, [$sp], 8
fldi.bi $fd9, [$sp], 8
fldi.bi $fd10, [$sp], 8
fldi.bi $fd11, [$sp], 8
fldi.bi $fd12, [$sp], 8
fldi.bi $fd13, [$sp], 8
fldi.bi $fd14, [$sp], 8
fldi.bi $fd15, [$sp], 8
#endif
#if ( portFPU_REGS > 32 )
fldi.bi $fd16, [$sp], 8
fldi.bi $fd17, [$sp], 8
fldi.bi $fd18, [$sp], 8
fldi.bi $fd19, [$sp], 8
fldi.bi $fd20, [$sp], 8
fldi.bi $fd21, [$sp], 8
fldi.bi $fd22, [$sp], 8
fldi.bi $fd23, [$sp], 8
fldi.bi $fd24, [$sp], 8
fldi.bi $fd25, [$sp], 8
fldi.bi $fd26, [$sp], 8
fldi.bi $fd27, [$sp], 8
fldi.bi $fd28, [$sp], 8
fldi.bi $fd29, [$sp], 8
fldi.bi $fd30, [$sp], 8
fldi.bi $fd31, [$sp], 8
#endif
#endif
.endm
/*-----------------------------------------------------------*/

.macro portSAVE_FPU_CALLER
#if ( configSUPPORT_FPU == 1 )
addi    $sp, $sp, -8
#if ( portFPU_REGS > 32 )
fsdi.bi $fd23, [$sp], -8
fsdi.bi $fd22, [$sp], -8
fsdi.bi $fd21, [$sp], -8
fsdi.bi $fd20, [$sp], -8
fsdi.bi $fd19, [$sp], -8
fsdi.bi $fd18, [$sp], -8
fsdi.bi $fd17, [$sp], -8
fsdi.bi $fd16, [$sp], -8
#endif
#if ( portFPU_REGS > 16 )
fsdi.bi $fd15, [$sp], -8
fsdi.bi $fd14, [$sp], -8
fsdi.bi $fd13, [$sp], -8
fsdi.bi $fd12, [$sp], -8
fsdi.bi $fd11, [$sp], -8
#endif
fsdi.bi $fd2, [$sp], -8
fsdi.bi $fd1, [$sp], -8
fsdi    $fd0, [$sp + 0]
#endif
.endm

.macro portRESTORE_FPU_CALLER
#if ( configSUPPORT_FPU == 1 )
fldi.bi $fd0, [$sp], 8
fldi.bi $fd1, [$sp], 8
fldi.bi $fd2, [$sp], 8
#if ( portFPU_REGS > 16 )
fldi.bi $fd11, [$sp], 8
fldi.bi $fd12, [$sp], 8
fldi.bi $fd13, [$sp], 8
fldi.bi $fd14, [$sp], 8
fldi.bi $fd15, [$sp], 8
#endif
#if ( portFPU_REGS > 32 )
fldi.bi $fd16, [$sp], 8
fldi.bi $fd17, [$sp], 8
fldi.bi $fd18, [$sp], 8
fldi.bi $fd19, [$sp], 8
fldi.bi $fd20, [$sp], 8
fldi.bi $fd21, [$sp], 8
fldi.bi $fd22, [$sp], 8
fldi.bi $fd23, [$sp], 8
#endif
#endif
.endm
/*-----------------------------------------------------------*/

.macro portSAVE_CONTEXT
pushm   $r28, $r30
/* We enter here with the orginal $r28~$r30 (fp/gp/lp) is saved */
pushm   $r0, $r25

mfsr    $r1, $IPC
mfsr    $r2, $IPSW

#if ( configSUPPORT_IFC ==1 ) && ( configSUPPORT_ZOL == 1)
mfusr   $r3, $LB
mfusr   $r4, $LE
mfusr   $r5, $LC
mfusr   $r6, $IFC_LP
pushm   $r0, $r6        /* $0 is dummy */
#elif ( configSUPPORT_ZOL == 1 )
mfusr   $r3, $LB
mfusr   $r4, $LE
mfusr   $r5, $LC
pushm   $r1, $r5
#elif ( configSUPPORT_IFC ==1 )
mfusr   $r3, $IFC_LP
pushm   $r1, $r3
#else
pushm   $r0, $r2        /* $0 is dummy */
#endif

portSAVE_FPU
.endm

.macro portRESTORE_CONTEXT
portRESTORE_FPU

setgie.d
dsb

#if ( configSUPPORT_IFC ==1 ) && ( configSUPPORT_ZOL == 1)
popm    $r0, $r6        /* $0 is dummy */
mtusr   $r3, $LB
mtusr   $r4, $LE
mtusr   $r5, $LC
mtusr   $r6, $IFC_LP
#elif ( configSUPPORT_ZOL == 1 )
popm    $r1, $r5
mtusr   $r3, $LB
mtusr   $r4, $LE
mtusr   $r5, $LC
#elif ( configSUPPORT_IFC ==1 )
popm    $r1, $r3
mtusr   $r3, $IFC_LP
#else
popm    $r0, $r2        /* $0 is dummy */
#endif

mtsr    $r1, $IPC
mtsr    $r2, $IPSW

popm    $r0, $r25
popm    $r28, $r30
.endm
/*-----------------------------------------------------------*/

// .macro portSAVE_CALLER
//  pushm   $r0, $r5
//  pushm   $r15,$r30               /* full: 16 gpr, reduce: 4 gpr */

//  portSAVE_FPU_CALLER
// .endm

// .macro portRESTORE_CALLER
//  portRESTORE_FPU_CALLER

//  popm    $r15,$r30               /* full: 16 gpr, reduce: 4 gpr*/
//  popm    $r0, $r5
// .endm

#endif

#ifdef __cplusplus
}
#endif

#endif /* ISR_SUPPORT_H */
